/****** Object:  StoredProcedure [dbo].[P_LOJA_NOVA]    Script Date: 10/07/2012 18:09:10 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_REPLICA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_REPLICA]
GO
GO

--EXEC P_EST_PROD_PRECO_REPLICA  2,1
--Procedure para replicar cadastro complementar de produtos e preos
CREATE PROCEDURE [dbo].[P_EST_PROD_PRECO_REPLICA] ( @IN_CD_FILIAL_BASE	  Int= 1,  
													@IN_CD_FILIAL_DESTINO Int= 1,
													@Preco_zerado TinyInt=1) AS  

------------------------------------------------------------------------------------------------------------
--Replicando preos
INSERT INTO EST_PROD_PRECO
	(CD_EMP,CD_FILIAL,CD_CTR,CD_PROD,VLR_TABELA,VLR_OFERTA,DT_CAD,
		CD_USU,STS_PRECO,VLR_CUSTO,PERC_ICMS,PERC_IMP,PERC_COMIS,PERC_DESP,PERC_MARGEM,STS_IMP_ETQ_GOND,VLR_TABELA_ANT,VLR_OFERTA_ANT,VLR_CUSTO_GER)
	SELECT
		 EST_PROD_PRECO.CD_EMP
		,@IN_CD_FILIAL_DESTINO AS CD_FILIAL
		,EST_PROD_PRECO.CD_CTR
		,EST_PROD_PRECO.CD_PROD
		,EST_PROD_PRECO.VLR_TABELA
		,EST_PROD_PRECO.VLR_OFERTA
		,EST_PROD_PRECO.DT_CAD
		,EST_PROD_PRECO.CD_USU
		,EST_PROD_PRECO.STS_PRECO
		,EST_PROD_PRECO.VLR_CUSTO
		,EST_PROD_PRECO.PERC_ICMS
		,EST_PROD_PRECO.PERC_IMP
		,EST_PROD_PRECO.PERC_COMIS
		,EST_PROD_PRECO.PERC_DESP
		,EST_PROD_PRECO.PERC_MARGEM
		,EST_PROD_PRECO.STS_IMP_ETQ_GOND
		,EST_PROD_PRECO.VLR_TABELA_ANT
		,EST_PROD_PRECO.VLR_OFERTA_ANT
		,0 AS VLR_CUSTO_GER
	FROM
		 EST_PROD_PRECO
	WHERE EST_PROD_PRECO.CD_EMP=1
		  AND EST_PROD_PRECO.CD_FILIAL=@IN_CD_FILIAL_BASE
		  AND NOT EXISTS(SELECT CD_EMP FROM EST_PROD_PRECO AS PRECO
							WHERE EST_PROD_PRECO.CD_EMP=PRECO.CD_EMP
								AND @IN_CD_FILIAL_DESTINO=PRECO.CD_FILIAL
								AND EST_PROD_PRECO.CD_PROD=PRECO.CD_PROD)
		  AND EXISTS(SELECT CD_EMP
					  FROM
						   EST_PROD_CPL
					  WHERE EST_PROD_PRECO.CD_EMP=EST_PROD_CPL.CD_EMP
							AND @IN_CD_FILIAL_DESTINO=EST_PROD_CPL.CD_FILIAL
							AND EST_PROD_PRECO.CD_PROD=EST_PROD_CPL.CD_PROD
	);

------------------------------------------------------------------------------------------------------------
--Tabela temporario dos precos para serem replicados
CREATE TABLE #RsProdPreco (CD_EMP     INT
							,CD_FILIAL  INT
							,CD_PROD    INT
							,VLR_TABELA MONEY
							,VLR_OFERTA MONEY);

------------------------------------------------------------------------------------------------------------
--Inserindo dados para replicacao
 
	INSERT INTO #RsProdPreco
	SELECT
		 CD_EMP
		,@IN_CD_FILIAL_DESTINO
		,CD_PROD
		,VLR_TABELA
		,VLR_OFERTA
	FROM
		 EST_PROD_PRECO
	WHERE CD_EMP=1
		  AND CD_FILIAL=@IN_CD_FILIAL_BASE;
 
	

------------------------------------------------------------------------------------------------------------	
--Atualizando o preco da filial destino	

--Todos os produtos
If @Preco_zerado =0
begin
	UPDATE
		EST_PROD_PRECO
	SET 	
		EST_PROD_PRECO.VLR_TABELA= p.VLR_TABELA,
		EST_PROD_PRECO.VLR_OFERTA= p.VLR_OFERTA
	FROM
		EST_PROD_PRECO INNER JOIN #RsProdPreco p ON
		EST_PROD_PRECO.CD_EMP = p.CD_EMP AND
		EST_PROD_PRECO.CD_FILIAL = p.CD_FILIAL AND
		EST_PROD_PRECO.CD_PROD = p.CD_PROD
	where
		 EST_PROD_PRECO.CD_EMP = 1
end

--Apenas produtos com preco zerado
If @Preco_zerado =1
begin
	UPDATE
		EST_PROD_PRECO
	SET 	
		EST_PROD_PRECO.VLR_TABELA= p.VLR_TABELA,
		EST_PROD_PRECO.VLR_OFERTA= p.VLR_OFERTA
	FROM
		EST_PROD_PRECO INNER JOIN #RsProdPreco p ON
		EST_PROD_PRECO.CD_EMP = p.CD_EMP AND
		EST_PROD_PRECO.CD_FILIAL = p.CD_FILIAL AND
		EST_PROD_PRECO.CD_PROD = p.CD_PROD 
	where
		EST_PROD_PRECO.CD_EMP = 1
		and EST_PROD_PRECO.VLR_TABELA=0
end